<!--
Thank you for submitting an issue!

Before opening a new issue, please search for keywords in the existing [list of issues](https://gitlab.com/libeigen/eigen/-/issues?state=opened) to verify it isn't a duplicate.
-->

### Summary
<!-- Summarize the bug encountered concisely. -->

### Environment
<!-- Please provide your development environment. -->
- **Operating System** : Windows/Linux
- **Architecture** : x64/Arm64/PowerPC ...
- **Eigen Version** : 5.0.0
- **Compiler Version** : gcc-12.0
- **Compile Flags** : -O3 -march=native
- **Vector Extension** : SSE/AVX/NEON ...

### Minimal Example
<!--
Please create a minimal reproducing example here that exhibits the problematic behavior.
The example should be complete, in that it can fully build and run.  See the [the guidelines on stackoverflow](https://stackoverflow.com/help/minimal-reproducible-example) for how to create a good minimal example.

You can also link to [godbolt](https://godbolt.org). Note that you need to click 
the "Share" button in the top right-hand corner of the godbolt page to get the share link
instead of the URL in your browser address bar. 
-->

```cpp
// Insert  your code here.
```

### Steps to reproduce the issue
<!-- Describe the necessary steps to reproduce the issue. -->

1. first step
2. second step
3. ... 

### What is the current *bug* behavior?
<!-- Describe what actually happens. -->

### What is the expected *correct* behavior?
<!-- Describe what you should see instead. -->

### Relevant logs
<!-- Add relevant build logs or program output within blocks marked by " ``` " -->

### [Optional] Benchmark scripts and results
<!-- Please share any benchmark scripts - either standalone, or using [Google Benchmark](https://github.com/google/benchmark). -->

### Anything else that might help
<!--
It will be better to provide us more information to help narrow down the cause. 
Including but not limited to the following: 
- lines of code that might help us diagnose the problem. 
- potential ways to address the issue.
- last known working/first broken version (release number or commit hash).
--> 
